//Calcul de la vitesse du son avec Arduino
//Affichage du temps de reception d'un écho
//Prof-TC - 12/2019

// Paramètres
int emetteur = 13;  //branché sur trig du HC-SR04
int recepteur = 12; //branché sur echo du HC-SR04
long dureeEcho;     //variable type long  

void setup() {
  Serial.begin (9600);
  pinMode(emetteur, OUTPUT); 
  pinMode(recepteur, INPUT);
}

void loop() {
  //Émission d'un pulse ultrason sur le pin 13: emetteur allumé pour 10 microsecondes
  digitalWrite(emetteur, HIGH);
  delayMicroseconds(10); // Added this line
  digitalWrite(emetteur, LOW);

  //Mesure du temps de reception de l'écho sur le pin 12
  dureeEcho = pulseIn(recepteur, HIGH);

  //Affichage du temps en ms, rafraichi toutes les 1000ms
  Serial.print("Duree = ");
  Serial.println(dureeEcho);
  
  // petite pause entre 2 mesures
  delay (1000);
}
